/********************************************************************
 * (C) Copyright 1998 by Hewlett-Packard GmbH. All rights reserved. *
 ********************************************************************/

/* ***********************************************************************
   *                                                                     *
   * sstdefs.h                                                           *
   * Christian Zurhorst, BVS R&D, 24. Jul. 1998                          *
   *                                                                     *
   * SST definitions                                                     *
   *                                                                     *
   ***********************************************************************
*/


#ifndef __SSTDEFS_H
#define __SSTDEFS_H

#define CLI


CLI typedef enum {
    B_SSTID_INTERN = 0,    /* @intern */
    B_SSTID_CFGCHECK,      /* @cfgcheck */
    B_SSTID_PROTCHECK,     /* @protcheck */
    B_SSTID_BWCONSUME,     /* @bwconsume */
    B_SSTID_MEMREAD,       /* @memread */
    B_SSTID_SYSTEMMEM,     /* @systemmem */
    B_SSTID_INTERRUPT,     /* @intr */
    B_SSTID_LAST = B_SSTID_INTERRUPT
} b_sstidtype;


#define B_SSTCFG_SIZE	3

CLI typedef enum {
    B_SSTCFG_CTRL = 0,    /* @ctrl */
    B_SSTCFG_SHELL,       /* @shell */
    B_SSTCFG_HOST         /* @host */
} b_sstcfgproptype;


#define B_SSTPROP_SIZE	50

CLI typedef enum {
    B_SSTPAR_EVENT = 0,       /* @event */
    B_SSTPAR_ID,              /* @id */
    B_SSTPAR_DURATION,        /* @duration */
    B_SSTPAR_QUERYINTERVAL,   /* @queryinterval */
    B_SSTPAR_AUTOMASK,        /* @automask */
    B_SSTPAR_BUSUTIL,         /* @busutil */
    B_SSTPAR_PROT1,           /* @prot1 */
    B_SSTPAR_PROT2,           /* @prot2 */
    B_SSTPAR_APAGE1,          /* @apage1 */
    B_SSTPAR_APAGE2,          /* @apage2 */
    B_SSTPAR_TRACEMEM,        /* @tracemem */
    B_SSTPAR_TRIGGER,         /* @trigger */
    B_SSTPAR_OBSERVER,        /* @observer */
    B_SSTPAR_DATAVAL1,        /* @dataval1 */
    B_SSTPAR_DATAVAL2,        /* @dataval2 */
    B_SSTPAR_DATAPATT,        /* @datapatt */
    B_SSTPAR_INTADDR,         /* @iad */
    B_SSTPAR_CONFIGSCAN,      /* @configscan */
    B_SSTPAR_HEARTBEATVALUE,  /* @hbvalue */
    B_SSTPAR_UTILLIMIT,       /* @utillimit */
    B_SSTPAR_STARTADDR1,      /* @saddr1 */
    B_SSTPAR_RANGE1,          /* @range1 */
    B_SSTPAR_STARTADDR2,      /* @saddr2 */
    B_SSTPAR_RANGE2,          /* @range2 */
    B_SSTPAR_ACCESSMODE,      /* @mode */
    B_SSTPAR_BLKSIZE,         /* @blksize */
    B_SSTPAR_ADDRSEQ,         /* @addrseq */
    B_SSTPAR_READCMD,         /* @readcmd */
    B_SSTPAR_RPTCOUNT,        /* @rptcount */
    B_SSTPAR_INT_OFFSET1,     /* @isaddr1 */
    B_SSTPAR_INT_OFFSET2,     /* @isaddr2 */
    B_SSTPAR_PERFORMANCE,     /* @perf */
    B_SSTPAR_PERFMODE,        /* @perfmode */
    B_SSTPAR_PERFREPORT,      /* @perfreport */
    B_SSTPAR_PERFREPINTV,     /* @perfintv */
    B_SSTPAR_PERFCTR1,        /* @perfctr1 */
    B_SSTPAR_PERFCTR2,        /* @perfctr2 */
    B_SSTPAR_INTROUTE,        /* @route */
    B_SSTPAR_INTALARM,        /* @alarm */
    B_SSTPAR_INTERRUPTMASK,   /* @intr */
    B_SSTPAR_INTGAP_A,        /* @gap_a */
    B_SSTPAR_ISRDWELL_A,      /* @dwell_a */
    B_SSTPAR_INTGAP_B,        /* @gap_b */
    B_SSTPAR_ISRDWELL_B,      /* @dwell_b */
    B_SSTPAR_INTGAP_C,        /* @gap_c */
    B_SSTPAR_ISRDWELL_C,      /* @dwell_c */
    B_SSTPAR_INTGAP_D,        /* @gap_d */
    B_SSTPAR_ISRDWELL_D,      /* @dwell_d */
    B_SSTPAR_INTCANCEL,       /* @cancel */
    B_SSTPAR_TRACEDEPTH       /* @tracedepth */
} b_sstproptype;


/***************************/
/* config property defines */
/***************************/

CLI /* DEF_START ~G_SSTCFG_CTRL */
#define B_CTRL_PROG       0x0   /* @prog */
#define B_CTRL_GUI        0x1   /* @gui */
#define B_CTRL_STANDALONE 0x2   /* @standalone */
CLI /* DEF_END */

CLI /* DEF_START ~G_SSTCFG_SHELL */
#define B_SHELL_NOT_USED        0x0   /* @nused */
#define B_SHELL_USED            0x1   /* @used */
CLI /* DEF_END */

CLI /* DEF_START ~G_SSTCFG_HOST */
#define B_HOST_DUT             0x0   /* @dut */
#define B_HOST_EXTERNAL        0x1   /* @external */
CLI /* DEF_END */


/*************************/
/* test property defines */
/*************************/

CLI /* DEF_START ~G_SSTPAR_ACCESSMODE */
#define B_ACCESSMODE_LINEAR              0x0    /* @linear */
#define B_ACCESSMODE_ROWHIT              0x1    /* @rowhit */
#define B_ACCESSMODE_ROWMISS             0x2    /* @rowmiss */
#define B_ACCESSMODE_SIMMMISS            0x3    /* @simmmiss */
CLI /* DEF_END */

CLI /* DEF_START ~G_SSTPAR_ADDRSEQ */
#define B_ADDRSEQ_LINEAR                 0x0    /* @linear */
#define B_ADDRSEQ_BUTTERFLY              0x1    /* @butterfly */
CLI /* DEF_END */

CLI /* DEF_START ~G_SSTPAR_CONFIGSCAN */
#define B_CONFIGSCAN_OFF                 0x0    /* @off */
#define B_CONFIGSCAN_AT_BEGIN            0x1    /* @atbegin */
#define B_CONFIGSCAN_AT_ERROR            0x2    /* @aterror */
CLI /* DEF_END */

CLI /* DEF_START ~G_SSTPAR_DATAPATT */
#define B_DATAPATT_CONSTANT              0x0    /* @constant */
#define B_DATAPATT_TOGGLE                0x1    /* @toggle */
#define B_DATAPATT_RANDOM                0x2    /* @random */
#define B_DATAPATT_ASIS                  0x3    /* @asis */
#define B_DATAPATT_COUNTUP               0x4    /* @countup */
#define B_DATAPATT_COUNTDOWN             0x5    /* @countdown */
#define B_DATAPATT_WALKINGONE            0x6    /* @walkone */
#define B_DATAPATT_WALKINGZERO           0x7    /* @walkzero */
CLI /* DEF_END */

CLI /* DEF_START ~G_SSTPAR_EVENT */
#define B_EVENT_RUN         0x0    /* @run */
#define B_EVENT_CONTINUE    0x1    /* @continue */
#define B_EVENT_STOP        0x2    /* @stop */
#define B_EVENT_ABORT       0x3    /* @abort */ /* dont change that order, it corresponds to target "abort" */
#define B_EVENT_FINISHED    0x4    /* @finished */
#define B_EVENT_PAUSE       0x5    /* @pause */
CLI /* DEF_END */

CLI /* DEF_START ~G_SSTPAR_INTCANCEL */
#define B_INTCANCEL_ONENTRY              0x0     /* @entry */
#define B_INTCANCEL_ONEXIT               0x1     /* @exit */
#define B_INTCANCEL_RANDOM               0x2     /* @random */
CLI /* DEF_END */

CLI /* DEF_START ~G_SSTPAR_INTROUTE */
#define B_INTROUTE_ON                    0x1     /* @on */
#define B_INTROUTE_OFF                   0x0     /* @on */
CLI /* DEF_END */

CLI /* DEF_START ~G_SSTPAR_OBSERVER */
#define B_OBSERVER_OFF         0x0    /* @off */
#define B_OBSERVER_ON          0x1    /* @on */
CLI /* DEF_END */

/* B_PERFCTR_A already defined in typedefs.h!! */
CLI /* DEF_START ~G_SSTPAR_PERFCTR */
#define B_PERFCTR_OFF                    0x0    /* @off */
#define B_PERFCTR_A_                     0x1    /* @a */
#define B_PERFCTR_A_REF                  0x2    /* @a_ref */
#define B_PERFCTR_B_                     0x3    /* @b */
#define B_PERFCTR_B_REF                  0x4    /* @b_ref */
#define B_PERFCTR_PRODAB                 0x5    /* @prod */
#define B_PERFCTR_QUOTAB                 0x6    /* @quot */
CLI /* DEF_END */

CLI /* DEF_START ~G_SSTPAR_PERFMODE */
#define B_PERFMODE_UTILIZATION           0x0    /* @util */
#define B_PERFMODE_THROUGHPUT            0x1    /* @thru */
#define B_PERFMODE_ASIS                  0x2    /* @asis */
CLI /* DEF_END */

CLI /* DEF_START ~G_SSTPAR_PERFORMANCE */
#define B_PERFORMANCE_OFF                0x0    /* @off */
#define B_PERFORMANCE_ON                 0x1    /* @on */
CLI /* DEF_END */

CLI /* DEF_START ~G_SSTPAR_PERFREPORT */
#define B_PERFREPORT_OFF                 0x0    /* @off */
#define B_PERFREPORT_ON_INTERVAL         0x1    /* @interval */
#define B_PERFREPORT_ON_ERROR            0x2    /* @error */
#define B_PERFREPORT_ALWAYS              0x3    /* @always */
CLI /* DEF_END */

CLI /* DEF_START ~G_SSTPAR_PROT */
#define B_PROT_LITE       0x0     /* @lite */
#define B_PROT_MEDIUM     0x1     /* @medium */
#define B_PROT_HARD       0x2     /* @hard */
#define B_PROT_ASIS       0x3     /* @asis */
CLI /* DEF_END */

CLI /* DEF_START ~G_SSTPAR_TRACEMEM */
#define B_TRACEMEM_OFF          0x0    /* @off */
#define B_TRACEMEM_ON           0x1    /* @on */
CLI /*DEF_END */

CLI /* DEF_START ~G_SSTPAR_TRIGGER */
#define B_TRIGGER_PROTVIOLATION    0x1    /* @protviolation */
#define B_TRIGGER_BUSHANGUP        0x2    /* @bushangup */
#define B_TRIGGER_ASIS             0x3    /* @asis */
CLI /* DEF_END */


/* ********************************************************************** */

/* other important structures */

#if ! (defined (BEST_FIRMWARE) || defined (MINIBIOS))

typedef struct {
    b_errtype (*event) (b_handletype, b_int32, b_int32 *);
    b_errtype (*report) (b_handletype, b_int32);
} b_sstcallbackentry;

#endif


/*******************/
/* callback events */
/*******************/

#define B_SST_EVENT_RETURN_CONTINUE    0x0
#define B_SST_EVENT_RETURN_STOP        0x1
#define B_SST_EVENT_RETURN_PAUSE       0x2
#define B_SST_EVENT_RETURN_ABORT       0x3


/******************/
/* report defines */
/******************/

/* parameter for the report callback function */
/* also stored in result buffer as report type */
#define B_SST_REPORT_HEADER   			0x0000
#define   B_SST_HEADER_TEST_START		0x0000
#define   B_SST_HEADER_CONTINUED       		0x0001

#define B_SST_REPORT_PARAMETER       		0x0001

#define B_SST_REPORT_STATUS          		0x0002
#define   B_SST_STATUS_NO_ERROR        		0x0000

#define B_SST_REPORT_PERFORMANCE     		0x0004
#define   B_SST_PERF_HEADER                	0x8000
#define   B_SST_PERF_MASTERUTIL            	0x0000
#define   B_SST_PERF_ALLUTIL               	0x0001
#define   B_SST_PERF_MASTERTHRU            	0x0010
#define   B_SST_PERF_ALLTHRU               	0x0011
#define   B_SST_PERF_CUSTOM_OFF                 0x0080
#define   B_SST_PERF_CUSTOM1               	0x0081
#define   B_SST_PERF_CUSTOM2               	0x0082

/* setup modifiers */
/* the setup report type is intended for system specific information that
   might be interesting for the operator but is beyond the accessible
   parameter set. Additional data is stored in the result buffer at offset
   0x30 - 0x3F */
#define B_SST_REPORT_SETUP           		0x0008
#define   B_SST_CONF_INT_ROUTE             	0x0001
   /* 0x30: level for INT A
      0x31:           INT B
      0x32:           INT C
      0x33:           INT D */

#define B_SST_REPORT_ERROR           		0x0010

#define B_SST_REPORT_OBSERVER			0x0011
#define B_SST_REPORT_MASTER                     0x0012

/* these values are used in for both, the 25 and 26 messages.
   The 26 defines several report types. */
#define   B_SST_ERROR_FIRST_PROT_ERR   		0x0000
#define   B_SST_ERROR_ACCUM_OBS_ERR    		0x0001
#define   B_SST_ERROR_BUSHANGUP        		0x0002
#define   B_SST_ERROR_INTR_A           		0x0003
#define   B_SST_ERROR_INTR_B           		0x0004
#define   B_SST_ERROR_INTR_C           		0x0005
#define   B_SST_ERROR_INTR_D           		0x0006
#define   B_SST_ERROR_MASK_PROT_ERR             0x0010

#define B_SST_REPORT_STANDALONE	     		0x0080

#define B_SST_REPORT_FOOTER          		0x1000
#define   B_SST_FOOTER_FINISHED        		0x0000
#define   B_SST_FOOTER_PAUSED          		0x0001
#define   B_SST_FOOTER_STOPPED         		0x0002
#define   B_SST_FOOTER_ABORTED         		0x0003
#define   B_SST_FOOTER_INTR_RESULT     		0x0004

#define B_SST_REPORT_CONFIG          		0x2000

#define B_SST_REPORT_SETUP_ERROR     		0x3000
#define   B_SST_SETUP_ERROR_TEST_INFINITE   	0x0000
#define   B_SST_SETUP_ERROR_QUERY_TOO_HIGH  	0x0001
#define   B_SST_SETUP_ERROR_NO_TARGET       	0x0002
#define   B_SST_SETUP_ERROR_NO_MASTER       	0x0003
#define   B_SST_SETUP_ERROR_NO_TM_ENABLE    	0x0004
#define   B_SST_SETUP_RANGE_TOO_SMALL       	0x0005
#define   B_SST_SETUP_NO_RANGE              	0x0006
#define   B_SST_SETUP_HEARTBEAT_TOO_SHORT   	0x0007
#define   B_SST_SETUP_ERROR_NO_IO           	0x0008
#define   B_SST_SETUP_ERROR_NO_PCICONNECT   	0x0009
#define   B_SST_SETUP_ERROR_UNABORTABLE	  	0x000a

#define B_SST_REPORT_ABORT           0x3001
/* qualifier is error return code */

#define B_SST_REPORT_WAVEFORM        0x4000
#define B_SST_REPORT_POSTPROC        0x5000
#define B_SST_REPORT_IDLE            0xFFFF


#define B_SST_STATUS_SIZE     1

CLI typedef enum {
  B_SST_STATUS_TEST           /* @test */
} b_sststatustype;


#define B_SST_STATUS_TEST_PASSED               0
#define B_SST_STATUS_TEST_FAILED               1


#if ! (defined (BEST_FIRMWARE) || defined (MINIBIOS))

typedef b_errtype (*b_ssttcall)(b_handletype handle);
typedef b_errtype (*b_sstrcall)(b_handletype handle,
                                const char * name);


typedef struct {
  b_sstidtype sstid;
  b_int8      hw_miniclass,
              hw_ichibanclass;
  b_ssttcall  sstcall;
  b_sstrcall  sstreport;
  const char *testname,
             *modulname;
} b_sstcatentry;

#endif


#endif


